/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "czas uniwersalny",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia (czas standardowy)",
               "",
               "Apia (czas letni)",
               "",
               "czas Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Wyspy Cooka (czas standardowy)",
               "",
               "Wyspy Cooka (czas letni)",
               "",
               "czas Wyspy Cooka",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba (czas standardowy)",
               "CST",
               "Kuba (czas letni)",
               "CDT",
               "czas Kuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ci (czas standardowy)",
               "",
               "Fid\u017ci (czas letni)",
               "",
               "czas Fid\u017ci",
               "",
            };
        final String[] Gulf = new String[] {
               "czas Zatoka Perska",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Kobdo (czas standardowy)",
               "",
               "Kobdo (czas letni)",
               "",
               "czas Kobdo",
               "",
            };
        final String[] Iran = new String[] {
               "Iran (czas standardowy)",
               "",
               "Iran (czas letni)",
               "",
               "czas Iran",
               "",
            };
        final String[] Niue = new String[] {
               "czas Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk (czas standardowy)",
               "",
               "Omsk (czas letni)",
               "",
               "czas Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Peru (czas standardowy)",
               "",
               "Peru (czas letni)",
               "",
               "czas Peru",
               "",
            };
        final String[] Truk = new String[] {
               "czas Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "czas Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chile (czas standardowy)",
               "",
               "Chile (czas letni)",
               "",
               "czas Chile",
               "",
            };
        final String[] China = new String[] {
               "Chiny (czas standardowy)",
               "CST",
               "Chiny (czas letni)",
               "CDT",
               "czas Chiny",
               "CT",
            };
        final String[] Cocos = new String[] {
               "czas Wyspy Kokosowe",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "czas Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "czas indyjski standardowy",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japonia (czas standardowy)",
               "JST",
               "Japonia (czas letni)",
               "JDT",
               "czas Japonia",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea (czas standardowy)",
               "KST",
               "Korea (czas letni)",
               "KST",
               "czas Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "czas Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "czas Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "czas Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa (czas standardowy)",
               "SST",
               "Samoa (czas letni)",
               "SST",
               "czas Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "czas Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga (czas standardowy)",
               "",
               "Tonga (czas letni)",
               "",
               "czas Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "czas Jukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska (czas standardowy)",
               "AKST",
               "Alaska (czas letni)",
               "AKDT",
               "czas Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "czas amazo\u0144ski standardowy",
               "",
               "czas amazo\u0144ski letni",
               "",
               "czas amazo\u0144ski",
               "",
            };
        final String[] Anadyr = new String[] {
               "czas standardowy Anadyr",
               "",
               "czas Anadyr letni",
               "",
               "czas Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Azory (czas standardowy)",
               "",
               "Azory (czas letni)",
               "",
               "czas Azory",
               "",
            };
        final String[] Bhutan = new String[] {
               "czas Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "czas Brunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Wyspa Wielkanocna (czas standardowy)",
               "",
               "Wyspa Wielkanocna (czas letni)",
               "",
               "czas Wyspa Wielkanocna",
               "",
            };
        final String[] Guyana = new String[] {
               "czas Gujana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Izrael (czas standardowy)",
               "IST",
               "Izrael (czas letni)",
               "IDT",
               "czas Izrael",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "czas Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "czas Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskwa (czas standardowy)",
               "MSK",
               "Moskwa (czas letni)",
               "MSK",
               "czas Moskwa",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "czas Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "czas standardowy Samara",
               "",
               "czas Samara letni",
               "",
               "czas Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "czas Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tajpej (czas standardowy)",
               "CST",
               "Tajpej (czas letni)",
               "CDT",
               "czas Tajpej",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "czas Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "czas Wostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "czas Wallis i Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "P\u00f3\u0142wysep Arabski (czas standardowy)",
               "",
               "P\u00f3\u0142wysep Arabski (czas letni)",
               "",
               "czas P\u00f3\u0142wysep Arabski",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia (czas standardowy)",
               "",
               "Armenia (czas letni)",
               "",
               "czas Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "czas Boliwia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham (czas standardowy)",
               "",
               "Chatham (czas letni)",
               "",
               "czas Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "uniwersalny czas koordynowany",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "czas Ekwador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "czas Wyspy Gambiera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzja (czas standardowy)",
               "",
               "Gruzja (czas letni)",
               "",
               "czas Gruzja",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkuck (czas standardowy)",
               "",
               "Irkuck (czas letni)",
               "",
               "czas Irkuck",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan (czas standardowy)",
               "",
               "Magadan (czas letni)",
               "",
               "czas Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "czas Mjanma",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk (czas standardowy)",
               "",
               "Norfolk (czas letni)",
               "",
               "czas Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha (czas standardowy)",
               "",
               "Fernando de Noronha (czas letni)",
               "",
               "czas Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "czas Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "czas Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "czas Wyspy Salomona",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "czas Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugwaj (czas standardowy)",
               "",
               "Urugwaj (czas letni)",
               "",
               "czas Urugwaj",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu (czas standardowy)",
               "",
               "Vanuatu (czas letni)",
               "",
               "czas Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakuck (czas standardowy)",
               "",
               "Jakuck (czas letni)",
               "",
               "czas Jakuck",
               "",
            };
        final String[] Atlantic = new String[] {
               "czas atlantycki standardowy",
               "AST",
               "czas atlantycki letni",
               "AST",
               "czas atlantycki",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia (czas standardowy)",
               "",
               "Bras\u00edlia (czas letni)",
               "",
               "czas Bras\u00edlia",
               "",
            };
        final String[] Chamorro = new String[] {
               "czas Czamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbia (czas standardowy)",
               "",
               "Kolumbia (czas letni)",
               "",
               "czas Kolumbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandy (czas standardowy)",
               "",
               "Falklandy (czas letni)",
               "",
               "czas Falklandy",
               "",
            };
        final String[] Malaysia = new String[] {
               "czas Malezja",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "czas Malediwy",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "U\u0142an Bator (czas standardowy)",
               "",
               "U\u0142an Bator (czas letni)",
               "",
               "czas U\u0142an Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan (czas standardowy)",
               "PKT",
               "Pakistan (czas letni)",
               "PKST",
               "czas Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragwaj (czas standardowy)",
               "",
               "Paragwaj (czas letni)",
               "",
               "czas Paragwaj",
               "",
            };
        final String[] Pitcairn = new String[] {
               "czas Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin (czas standardowy)",
               "",
               "Sachalin (czas letni)",
               "",
               "czas Sachalin",
               "",
            };
        final String[] Suriname = new String[] {
               "czas Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentyna (czas standardowy)",
               "",
               "Argentyna (czas letni)",
               "",
               "czas Argentyna",
               "",
            };
        final String[] Christmas = new String[] {
               "czas Wyspa Bo\u017cego Narodzenia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "czas Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong (czas standardowy)",
               "HKT",
               "Hongkong (czas letni)",
               "HKST",
               "czas Hongkong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "czas indochi\u0144ski",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "czas standardowy Pietropaw\u0142owsk Kamczacki",
               "",
               "czas Pietropaw\u0142owsk Kamczacki letni",
               "",
               "czas Pietropaw\u0142owsk Kamczacki",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "czas Kirgistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe (czas standardowy)",
               "",
               "Lord Howe (czas letni)",
               "",
               "czas Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "czas Markizy",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius (czas standardowy)",
               "",
               "Mauritius (czas letni)",
               "",
               "czas Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "czas Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "czas Wenezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wo\u0142gograd (czas standardowy)",
               "MSK",
               "Wo\u0142gograd (czas letni)",
               "MSK",
               "czas Wo\u0142gograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbejd\u017can (czas standardowy)",
               "",
               "Azerbejd\u017can (czas letni)",
               "",
               "czas Azerbejd\u017can",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesz (czas standardowy)",
               "",
               "Bangladesz (czas letni)",
               "",
               "czas Bangladesz",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Wyspy Zielonego Przyl\u0105dka (czas standardowy)",
               "",
               "Wyspy Zielonego Przyl\u0105dka (czas letni)",
               "",
               "czas Wyspy Zielonego Przyl\u0105dka",
               "",
            };
        final String[] East_Timor = new String[] {
               "czas Timor Wschodni",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "czas Kazachstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "czas Seszele",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "czas Tad\u017cykistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistan (czas standardowy)",
               "",
               "Uzbekistan (czas letni)",
               "",
               "czas Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "czas Afganistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk (czas standardowy)",
               "",
               "Krasnojarsk (czas letni)",
               "",
               "czas Krasnojarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nowa Zelandia (czas standardowy)",
               "NZST",
               "Nowa Zelandia (czas letni)",
               "NZDT",
               "czas Nowa Zelandia",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosybirsk (czas standardowy)",
               "",
               "Nowosybirsk (czas letni)",
               "",
               "czas Nowosybirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipiny (czas standardowy)",
               "PST",
               "Filipiny (czas letni)",
               "PDT",
               "czas Filipiny",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "W\u0142adywostok (czas standardowy)",
               "",
               "W\u0142adywostok (czas letni)",
               "",
               "czas W\u0142adywostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "czas Ocean Indyjski",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "czas Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Nowa Fundlandia (czas standardowy)",
               "NST",
               "Nowa Fundlandia (czas letni)",
               "NDT",
               "czas Nowa Fundlandia",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan (czas standardowy)",
               "",
               "Turkmenistan (czas letni)",
               "",
               "czas Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "czas Gujana Francuska",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nowa Kaledonia (czas standardowy)",
               "",
               "Nowa Kaledonia (czas letni)",
               "",
               "czas Nowa Kaledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "czas Georgia Po\u0142udniowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterynburg (czas standardowy)",
               "",
               "Jekaterynburg (czas letni)",
               "",
               "czas Jekaterynburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "czas \u015brodkowoafryka\u0144ski",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "czas wschodnioafryka\u0144ski",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "czas zachodnioafryka\u0144ski standardowy",
               "WAT",
               "czas zachodnioafryka\u0144ski letni",
               "WAT",
               "czas zachodnioafryka\u0144ski",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "czas Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "czas \u015brodkowoeuropejski standardowy",
               "CET",
               "czas \u015brodkowoeuropejski letni",
               "CEST",
               "czas \u015brodkowoeuropejski",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "czas wschodnioeuropejski standardowy",
               "EET",
               "czas wschodnioeuropejski letni",
               "EEST",
               "czas wschodnioeuropejski",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "czas zachodnioeuropejski standardowy",
               "WET",
               "czas zachodnioeuropejski letni",
               "WEST",
               "czas zachodnioeuropejski",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksyk (czas pacyficzny standardowy)",
               "MST",
               "Meksyk (czas pacyficzny letni)",
               "MDT",
               "Meksyk (czas pacyficzny)",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "czas po\u0142udniowoafryka\u0144ski",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "czas \u015brodkowoameryka\u0144ski standardowy",
               "CST",
               "czas \u015brodkowoameryka\u0144ski letni",
               "CDT",
               "czas \u015brodkowoameryka\u0144ski",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "czas wschodnioameryka\u0144ski standardowy",
               "EST",
               "czas wschodnioameryka\u0144ski letni",
               "EST",
               "czas wschodnioameryka\u0144ski",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "czas pacyficzny standardowy",
               "PST",
               "czas pacyficzny letni",
               "PDT",
               "czas pacyficzny",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "czas Francuskie Terytoria Po\u0142udniowe i Antarktyczne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "czas Wyspy Gilberta",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaje-Aleuty (czas standardowy)",
               "HST",
               "Hawaje-Aleuty (czas letni)",
               "HST",
               "czas Hawaje-Aleuty",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "czas Feniks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre i Miquelon (czas standardowy)",
               "",
               "Saint-Pierre i Miquelon (czas letni)",
               "",
               "czas Saint-Pierre i Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "czas g\u00f3rski standardowy",
               "MST",
               "czas g\u00f3rski letni",
               "MST",
               "czas g\u00f3rski",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "czas Wyspy Marshalla",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "czas Papua-Nowa Gwinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "czas \u015brodkowoaustralijski standardowy",
               "ACST",
               "czas \u015brodkowoaustralijski letni",
               "ACDT",
               "czas \u015brodkowoaustralijski",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "czas wschodnioaustralijski standardowy",
               "AEST",
               "czas wschodnioaustralijski letni",
               "AEDT",
               "czas wschodnioaustralijski",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "czas zachodnioaustralijski standardowy",
               "AWST",
               "czas zachodnioaustralijski letni",
               "AWDT",
               "czas zachodnioaustralijski",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "czas Indonezja \u015arodkowa",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "czas Indonezja Wschodnia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "czas Indonezja Zachodnia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "czas \u015brodkowo-zachodnioaustralijski standardowy",
               "",
               "czas \u015brodkowo-zachodnioaustralijski letni",
               "",
               "czas \u015brodkowo-zachodnioaustralijski",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Brytyjski czas letni",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "uniwersalny czas koordynowany",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Irlandia (czas letni)",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "uniwersalny czas koordynowany",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "uniwersalny czas koordynowany",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Brytyjski czas letni",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "uniwersalny czas koordynowany",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "uniwersalny czas koordynowany",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "uniwersalny czas koordynowany",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Irlandia (czas letni)",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Brytyjski czas letni",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Brytyjski czas letni",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Brytyjski czas letni",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Brytyjski czas letni",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "czas uniwersalny",
                    "GMT",
                    "Brytyjski czas letni",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Kobdo" },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Czyta" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Macau", "Makau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "D\u017cuba" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "A\u0142maty" },
            { "timezone.excity.Asia/Aqtobe", "Aktiubi\u0144sk" },
            { "timezone.excity.Asia/Beirut", "Bejrut" },
            { "timezone.excity.Asia/Kuwait", "Kuwejt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Rijad" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urumczi" },
            { "timezone.excity.Etc/Unknown", "Nieznane miasto" },
            { "timezone.excity.Europe/Kiev", "Kij\u00f3w" },
            { "timezone.excity.Europe/Riga", "Ryga" },
            { "timezone.excity.Europe/Rome", "Rzym" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kair" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Asia/Barnaul", "Barnau\u0142" },
            { "timezone.excity.Asia/Bishkek", "Biszkek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkuck" },
            { "timezone.excity.Asia/Jakarta", "D\u017cakarta" },
            { "timezone.excity.Asia/Karachi", "Karaczi" },
            { "timezone.excity.Asia/Nicosia", "Nikozja" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Yakutsk", "Jakuck" },
            { "timezone.excity.Asia/Yerevan", "Erywa\u0144" },
            { "timezone.excity.Europe/Kirov", "Kirow" },
            { "timezone.excity.Europe/Minsk", "Mi\u0144sk" },
            { "timezone.excity.Europe/Paris", "Pary\u017c" },
            { "timezone.excity.Indian/Cocos", "Wyspy Kokosowe" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ci" },
            { "timezone.excity.Africa/Bangui", "Bangi" },
            { "timezone.excity.Africa/Banjul", "Band\u017cul" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.America/Bahia", "Salvador" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Thule", "Qaanaaq" },
            { "timezone.excity.Asia/Ashgabat", "Aszchabad" },
            { "timezone.excity.Asia/Calcutta", "Kalkuta" },
            { "timezone.excity.Asia/Damascus", "Damaszek" },
            { "timezone.excity.Asia/Dushanbe", "Duszanbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Kustanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "Szanghaj" },
            { "timezone.excity.Asia/Tashkent", "Taszkient" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Niera" },
            { "timezone.excity.Europe/Athens", "Ateny" },
            { "timezone.excity.Europe/Lisbon", "Lizbona" },
            { "timezone.excity.Europe/London", "Londyn" },
            { "timezone.excity.Europe/Madrid", "Madryt" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskwa" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wiede\u0144" },
            { "timezone.excity.Europe/Warsaw", "Warszawa" },
            { "timezone.excity.Europe/Zagreb", "Zagrzeb" },
            { "timezone.excity.Europe/Zurich", "Zurych" },
            { "timezone.excity.Indian/Chagos", "Czagos" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abid\u017can" },
            { "timezone.excity.Africa/Algiers", "Algier" },
            { "timezone.excity.Africa/Conakry", "Konakry" },
            { "timezone.excity.Africa/Tripoli", "Trypolis" },
            { "timezone.excity.America/Cayman", "Kajmany" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Guyana", "Gujana" },
            { "timezone.excity.America/Havana", "Hawana" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jerozolima" },
            { "timezone.excity.Asia/Kamchatka", "Kamczatka" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzy\u0142orda" },
            { "timezone.excity.Asia/Samarkand", "Samarkanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Wientian" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Saratov", "Sarat\u00f3w" },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Europe/Vatican", "Watykan" },
            { "timezone.excity.Europe/Vilnius", "Wilno" },
            { "timezone.excity.Indian/Mayotte", "Majotta" },
            { "timezone.excity.Pacific/Easter", "Wyspa Wielkanocna" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Africa/Djibouti", "D\u017cibuti" },
            { "timezone.excity.Africa/El_Aaiun", "Al-Ujun" },
            { "timezone.excity.Africa/Khartoum", "Chartum" },
            { "timezone.excity.Africa/Kinshasa", "Kinszasa" },
            { "timezone.excity.Africa/Ndjamena", "Nd\u017camena" },
            { "timezone.excity.Africa/Windhoek", "Windhuk" },
            { "timezone.excity.America/Cayenne", "Kajenna" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.Atlantic/Azores", "Azory" },
            { "timezone.excity.Atlantic/Canary", "Wyspy Kanaryjskie" },
            { "timezone.excity.Atlantic/Faeroe", "Wyspy Owcze" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Bruksela" },
            { "timezone.excity.Europe/Budapest", "Budapeszt" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen am Hochrhein" },
            { "timezone.excity.Europe/Chisinau", "Kiszyni\u00f3w" },
            { "timezone.excity.Europe/Istanbul", "Stambu\u0142" },
            { "timezone.excity.Europe/Sarajevo", "Sarajewo" },
            { "timezone.excity.Indian/Maldives", "Malediwy" },
            { "timezone.excity.Pacific/Gambier", "Wyspy Gambiera" },
            { "timezone.excity.Africa/Bujumbura", "Bu\u017cumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiszu" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/New_York", "Nowy Jork" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosybirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "U\u0142an Bator" },
            { "timezone.excity.Asia/Vladivostok", "W\u0142adywostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Atlantic/Madeira", "Madera" },
            { "timezone.excity.Europe/Astrakhan", "Astracha\u0144" },
            { "timezone.excity.Europe/Bucharest", "Bukareszt" },
            { "timezone.excity.Europe/Ljubljana", "Lublana" },
            { "timezone.excity.Europe/Mariehamn", "Maarianhamina" },
            { "timezone.excity.Europe/Stockholm", "Sztokholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanowsk" },
            { "timezone.excity.Europe/Volgograd", "Wo\u0142gograd" },
            { "timezone.excity.Indian/Christmas", "Wyspa Bo\u017cego Narodzenia" },
            { "timezone.excity.Indian/Kerguelen", "Wyspy Kerguelena" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Nouakchott", "Nawakszut" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Guatemala", "Gwatemala" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Asia/Novokuznetsk", "Nowoku\u017anieck" },
            { "timezone.excity.Europe/Bratislava", "Bratys\u0142awa" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhaga" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "timezone.excity.Europe/Simferopol", "Symferopol" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "Markizy" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kostaryka" },
            { "timezone.excity.America/Guadeloupe", "Gwadelupa" },
            { "timezone.excity.America/Martinique", "Martynika" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Srednekolymsk", "Sriednieko\u0142ymsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterynburg" },
            { "timezone.excity.Atlantic/St_Helena", "\u015awi\u0119ta Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Wyspa Man" },
            { "timezone.excity.America/El_Salvador", "Salwador" },
            { "timezone.excity.America/Mexico_City", "Meksyk (miasto)" },
            { "timezone.excity.America/Puerto_Rico", "Portoryko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Republika Zielonego Przyl\u0105dka" },
            { "timezone.excity.Indian/Antananarivo", "Antananarywa" },
            { "timezone.excity.Pacific/Bougainville", "Wyspa Bougainville\u2019a" },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Spain" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia Po\u0142udniowa" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota P\u00f3\u0142nocna" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota P\u00f3\u0142nocna" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota P\u00f3\u0142nocna" },
        };
        return data;
    }
}
