/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import sun.jvm.hotspot.BsdVtblAccess;
import sun.jvm.hotspot.HotSpotSolarisVtblAccess;
import sun.jvm.hotspot.HotSpotTypeDataBase;
import sun.jvm.hotspot.LinuxVtblAccess;
import sun.jvm.hotspot.RMIHelper;
import sun.jvm.hotspot.Win32VtblAccess;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.MachineDescriptionAARCH64;
import sun.jvm.hotspot.debugger.MachineDescriptionAMD64;
import sun.jvm.hotspot.debugger.MachineDescriptionIA64;
import sun.jvm.hotspot.debugger.MachineDescriptionIntelX86;
import sun.jvm.hotspot.debugger.MachineDescriptionSPARC32Bit;
import sun.jvm.hotspot.debugger.MachineDescriptionSPARC64Bit;
import sun.jvm.hotspot.debugger.NoSuchSymbolException;
import sun.jvm.hotspot.debugger.bsd.BsdDebuggerLocal;
import sun.jvm.hotspot.debugger.linux.LinuxDebuggerLocal;
import sun.jvm.hotspot.debugger.proc.ProcDebuggerLocal;
import sun.jvm.hotspot.debugger.remote.RemoteDebugger;
import sun.jvm.hotspot.debugger.remote.RemoteDebuggerClient;
import sun.jvm.hotspot.debugger.remote.RemoteDebuggerServer;
import sun.jvm.hotspot.debugger.windbg.WindbgDebuggerLocal;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.PlatformInfo;
import sun.jvm.hotspot.utilities.UnsupportedPlatformException;

public class HotSpotAgent {
    private JVMDebugger debugger;
    private MachineDescription machDesc;
    private TypeDataBase db;
    private String os;
    private String cpu;
    private static final int PROCESS_MODE = 0;
    private static final int CORE_FILE_MODE = 1;
    private static final int REMOTE_MODE = 2;
    private int startupMode;
    private boolean isServer;
    private int pid;
    private String javaExecutableName;
    private String coreFileName;
    private String debugServerID;
    private String serverID;
    private String[] jvmLibNames;

    static void showUsage() {
    }

    public HotSpotAgent() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HotSpotAgent hotSpotAgent = HotSpotAgent.this;
                synchronized (hotSpotAgent) {
                    if (!HotSpotAgent.this.isServer) {
                        HotSpotAgent.this.detach();
                    }
                }
            }
        }));
    }

    public synchronized Debugger getDebugger() {
        return this.debugger;
    }

    public synchronized TypeDataBase getTypeDataBase() {
        return this.db;
    }

    public synchronized void attach(int processID) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        this.pid = processID;
        this.startupMode = 0;
        this.isServer = false;
        this.go();
    }

    public synchronized void attach(String javaExecutableName, String coreFileName) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        if (javaExecutableName == null || coreFileName == null) {
            throw new DebuggerException("Both the core file name and Java executable name must be specified");
        }
        this.javaExecutableName = javaExecutableName;
        this.coreFileName = coreFileName;
        this.startupMode = 1;
        this.isServer = false;
        this.go();
    }

    public synchronized void attach(JVMDebugger d) throws DebuggerException {
        this.debugger = d;
        this.isServer = false;
        this.go();
    }

    public synchronized void attach(String remoteServerID) throws DebuggerException {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached to a process");
        }
        if (remoteServerID == null) {
            throw new DebuggerException("Debug server id must be specified");
        }
        this.debugServerID = remoteServerID;
        this.startupMode = 2;
        this.isServer = false;
        this.go();
    }

    public synchronized boolean detach() throws DebuggerException {
        if (this.isServer) {
            throw new DebuggerException("Should not call detach() for server configuration");
        }
        return this.detachInternal();
    }

    public synchronized void startServer(int processID, String uniqueID) {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        this.pid = processID;
        this.startupMode = 0;
        this.isServer = true;
        this.serverID = uniqueID;
        this.go();
    }

    public synchronized void startServer(int processID) throws DebuggerException {
        this.startServer(processID, null);
    }

    public synchronized void startServer(String javaExecutableName, String coreFileName, String uniqueID) {
        if (this.debugger != null) {
            throw new DebuggerException("Already attached");
        }
        if (javaExecutableName == null || coreFileName == null) {
            throw new DebuggerException("Both the core file name and Java executable name must be specified");
        }
        this.javaExecutableName = javaExecutableName;
        this.coreFileName = coreFileName;
        this.startupMode = 1;
        this.isServer = true;
        this.serverID = uniqueID;
        this.go();
    }

    public synchronized void startServer(String javaExecutableName, String coreFileName) throws DebuggerException {
        this.startServer(javaExecutableName, coreFileName, null);
    }

    public synchronized boolean shutdownServer() throws DebuggerException {
        if (!this.isServer) {
            throw new DebuggerException("Should not call shutdownServer() for client configuration");
        }
        return this.detachInternal();
    }

    private boolean detachInternal() {
        if (this.debugger == null) {
            return false;
        }
        boolean retval = true;
        if (!this.isServer) {
            VM.shutdown();
        }
        JVMDebugger dbg = null;
        DebuggerException ex = null;
        if (this.isServer) {
            try {
                RMIHelper.unbind(this.serverID);
            }
            catch (DebuggerException de) {
                ex = de;
            }
            dbg = this.debugger;
        } else if (this.startupMode != 2) {
            dbg = this.debugger;
        }
        if (dbg != null) {
            retval = dbg.detach();
        }
        this.debugger = null;
        this.machDesc = null;
        this.db = null;
        if (ex != null) {
            throw ex;
        }
        return retval;
    }

    private void go() {
        this.setupDebugger();
        this.setupVM();
    }

    private void setupDebugger() {
        if (this.startupMode != 2) {
            String alternateDebugger = System.getProperty("sa.altDebugger");
            if (this.debugger != null) {
                this.setupDebuggerExisting();
            } else if (alternateDebugger != null) {
                this.setupDebuggerAlternate(alternateDebugger);
            } else {
                try {
                    this.os = PlatformInfo.getOS();
                    this.cpu = PlatformInfo.getCPU();
                }
                catch (UnsupportedPlatformException e) {
                    throw new DebuggerException(e);
                }
                if (this.os.equals("solaris")) {
                    this.setupDebuggerSolaris();
                } else if (this.os.equals("win32")) {
                    this.setupDebuggerWin32();
                } else if (this.os.equals("linux")) {
                    this.setupDebuggerLinux();
                } else if (this.os.equals("bsd")) {
                    this.setupDebuggerBsd();
                } else if (this.os.equals("darwin")) {
                    this.setupDebuggerDarwin();
                } else {
                    throw new DebuggerException("Operating system " + this.os + " not yet supported");
                }
            }
            if (this.isServer) {
                RemoteDebuggerServer remote = null;
                try {
                    remote = new RemoteDebuggerServer(this.debugger);
                }
                catch (RemoteException rem) {
                    throw new DebuggerException(rem);
                }
                RMIHelper.rebind(this.serverID, remote);
            }
        } else {
            this.connectRemoteDebugger();
        }
    }

    private void setupVM() {
        block12: {
            try {
                if (this.os.equals("solaris")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new HotSpotSolarisVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block12;
                }
                if (this.os.equals("win32")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new Win32VtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block12;
                }
                if (this.os.equals("linux")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new LinuxVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block12;
                }
                if (this.os.equals("bsd")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new BsdVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block12;
                }
                if (this.os.equals("darwin")) {
                    this.db = new HotSpotTypeDataBase(this.machDesc, new BsdVtblAccess(this.debugger, this.jvmLibNames), this.debugger, this.jvmLibNames);
                    break block12;
                }
                throw new DebuggerException("OS \"" + this.os + "\" not yet supported (no VtblAccess yet)");
            }
            catch (NoSuchSymbolException e) {
                throw new DebuggerException("Doesn't appear to be a HotSpot VM (could not find symbol \"" + e.getSymbol() + "\" in remote process)");
            }
        }
        if (this.startupMode != 2) {
            this.debugger.configureJavaPrimitiveTypeSizes(this.db.getJBooleanType().getSize(), this.db.getJByteType().getSize(), this.db.getJCharType().getSize(), this.db.getJDoubleType().getSize(), this.db.getJFloatType().getSize(), this.db.getJIntType().getSize(), this.db.getJLongType().getSize(), this.db.getJShortType().getSize());
        }
        if (!this.isServer) {
            try {
                VM.initialize(this.db, this.debugger);
            }
            catch (DebuggerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DebuggerException(e);
            }
        }
    }

    private void setupDebuggerExisting() {
        this.os = this.debugger.getOS();
        this.cpu = this.debugger.getCPU();
        this.setupJVMLibNames(this.os);
        this.machDesc = this.debugger.getMachineDescription();
    }

    private void setupDebuggerAlternate(String alternateName) {
        try {
            Class<?> c = Class.forName(alternateName);
            Constructor<?> cons = c.getConstructor(new Class[0]);
            this.debugger = (JVMDebugger)cons.newInstance(new Object[0]);
            this.attachDebugger();
            this.setupDebuggerExisting();
        }
        catch (ClassNotFoundException cnfe) {
            throw new DebuggerException("Cannot find alternate SA Debugger: '" + alternateName + "'");
        }
        catch (NoSuchMethodException nsme) {
            throw new DebuggerException("Alternate SA Debugger: '" + alternateName + "' has missing constructor.");
        }
        catch (InstantiationException ie) {
            throw new DebuggerException("Alternate SA Debugger: '" + alternateName + "' fails to initialise: ", ie);
        }
        catch (IllegalAccessException iae) {
            throw new DebuggerException("Alternate SA Debugger: '" + alternateName + "' fails to initialise: ", iae);
        }
        catch (InvocationTargetException iae) {
            throw new DebuggerException("Alternate SA Debugger: '" + alternateName + "' fails to initialise: ", iae);
        }
        System.err.println("Loaded alternate HotSpot SA Debugger: " + alternateName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupDebuggerSolaris() {
        this.setupJVMLibNamesSolaris();
        ProcDebuggerLocal dbg = new ProcDebuggerLocal(null, true);
        this.debugger = dbg;
        this.attachDebugger();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("sparc")) {
            int addressSize = dbg.getRemoteProcessAddressSize();
            if (addressSize == -1) {
                throw new DebuggerException("Error occurred while trying to determine the remote process's address size");
            }
            if (addressSize == 32) {
                this.machDesc = new MachineDescriptionSPARC32Bit();
            } else {
                if (addressSize != 64) throw new DebuggerException("Address size " + addressSize + " is not supported on SPARC");
                this.machDesc = new MachineDescriptionSPARC64Bit();
            }
        } else {
            if (!this.cpu.equals("amd64")) throw new DebuggerException("Solaris only supported on sparc/sparcv9/x86/amd64");
            this.machDesc = new MachineDescriptionAMD64();
        }
        dbg.setMachineDescription(this.machDesc);
    }

    private void connectRemoteDebugger() throws DebuggerException {
        RemoteDebugger remote = (RemoteDebugger)RMIHelper.lookup(this.debugServerID);
        this.debugger = new RemoteDebuggerClient(remote);
        this.machDesc = ((RemoteDebuggerClient)this.debugger).getMachineDescription();
        this.os = this.debugger.getOS();
        this.setupJVMLibNames(this.os);
        this.cpu = this.debugger.getCPU();
    }

    private void setupJVMLibNames(String os) {
        if (os.equals("solaris")) {
            this.setupJVMLibNamesSolaris();
        } else if (os.equals("win32")) {
            this.setupJVMLibNamesWin32();
        } else if (os.equals("linux")) {
            this.setupJVMLibNamesLinux();
        } else if (os.equals("bsd")) {
            this.setupJVMLibNamesBsd();
        } else if (os.equals("darwin")) {
            this.setupJVMLibNamesDarwin();
        } else {
            throw new RuntimeException("Unknown OS type");
        }
    }

    private void setupJVMLibNamesSolaris() {
        this.jvmLibNames = new String[]{"libjvm.so"};
    }

    private void setupDebuggerWin32() {
        this.setupJVMLibNamesWin32();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("amd64")) {
            this.machDesc = new MachineDescriptionAMD64();
        } else if (this.cpu.equals("ia64")) {
            this.machDesc = new MachineDescriptionIA64();
        } else {
            throw new DebuggerException("Win32 supported under x86, amd64 and ia64 only");
        }
        this.debugger = new WindbgDebuggerLocal(this.machDesc, !this.isServer);
        this.attachDebugger();
    }

    private void setupJVMLibNamesWin32() {
        this.jvmLibNames = new String[]{"jvm.dll"};
    }

    private void setupDebuggerLinux() {
        this.setupJVMLibNamesLinux();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("ia64")) {
            this.machDesc = new MachineDescriptionIA64();
        } else if (this.cpu.equals("amd64")) {
            this.machDesc = new MachineDescriptionAMD64();
        } else if (this.cpu.equals("sparc")) {
            this.machDesc = LinuxDebuggerLocal.getAddressSize() == 8 ? new MachineDescriptionSPARC64Bit() : new MachineDescriptionSPARC32Bit();
        } else {
            try {
                this.machDesc = (MachineDescription)Class.forName("sun.jvm.hotspot.debugger.MachineDescription" + this.cpu.toUpperCase()).newInstance();
            }
            catch (Exception e) {
                throw new DebuggerException("Linux not supported on machine type " + this.cpu);
            }
        }
        LinuxDebuggerLocal dbg = new LinuxDebuggerLocal(this.machDesc, !this.isServer);
        this.debugger = dbg;
        this.attachDebugger();
    }

    private void setupJVMLibNamesLinux() {
        this.jvmLibNames = new String[]{"libjvm.so"};
    }

    private void setupDebuggerBsd() {
        this.setupJVMLibNamesBsd();
        if (this.cpu.equals("x86")) {
            this.machDesc = new MachineDescriptionIntelX86();
        } else if (this.cpu.equals("amd64") || this.cpu.equals("x86_64")) {
            this.machDesc = new MachineDescriptionAMD64();
        } else {
            throw new DebuggerException("BSD only supported on x86/x86_64. Current arch: " + this.cpu);
        }
        BsdDebuggerLocal dbg = new BsdDebuggerLocal(this.machDesc, !this.isServer);
        this.debugger = dbg;
        this.attachDebugger();
    }

    private void setupJVMLibNamesBsd() {
        this.jvmLibNames = new String[]{"libjvm.so"};
    }

    private void setupDebuggerDarwin() {
        this.setupJVMLibNamesDarwin();
        if (this.cpu.equals("amd64") || this.cpu.equals("x86_64")) {
            this.machDesc = new MachineDescriptionAMD64();
        } else if (this.cpu.equals("aarch64")) {
            this.machDesc = new MachineDescriptionAARCH64();
        } else {
            throw new DebuggerException("Darwin only supported on x86_64 and aarch64. Current arch: " + this.cpu);
        }
        BsdDebuggerLocal dbg = new BsdDebuggerLocal(this.machDesc, !this.isServer);
        this.debugger = dbg;
        this.attachDebugger();
    }

    private void setupJVMLibNamesDarwin() {
        this.jvmLibNames = new String[]{"libjvm.dylib"};
    }

    private void attachDebugger() {
        if (this.startupMode == 0) {
            this.debugger.attach(this.pid);
        } else if (this.startupMode == 1) {
            this.debugger.attach(this.javaExecutableName, this.coreFileName);
        } else {
            throw new DebuggerException("Should not call attach() for startupMode == " + this.startupMode);
        }
    }
}

