/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.MonocleApplication;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.RunnableProcessor;
import java.util.BitSet;

class MouseInput {
    private static MouseInput instance = new MouseInput();
    private MouseState state = new MouseState();
    private IntSet buttons = new IntSet();
    private boolean dragInProgress = false;
    private int dragButton = 211;
    private MonocleView dragView = null;
    private BitSet dragActions = new BitSet();
    private static final int DRAG_ENTER = 1;
    private static final int DRAG_LEAVE = 2;
    private static final int DRAG_OVER = 3;
    private static final int DRAG_DROP = 4;

    MouseInput() {
    }

    static MouseInput getInstance() {
        return instance;
    }

    void getState(MouseState mouseState) {
        this.state.copyTo(mouseState);
    }

    void setState(MouseState mouseState, boolean bl) {
        boolean bl2;
        int n;
        int n2;
        int n3;
        int n4;
        MonocleView monocleView;
        if (MonocleSettings.settings.traceEvents) {
            MonocleTrace.traceEvent("Set %s", mouseState);
        }
        NativeScreen nativeScreen = NativePlatformFactory.getNativePlatform().getScreen();
        int n5 = Math.max(0, Math.min(mouseState.getX(), nativeScreen.getWidth() - 1));
        int n6 = Math.max(0, Math.min(mouseState.getY(), nativeScreen.getHeight() - 1));
        mouseState.setX(n5);
        mouseState.setY(n6);
        MonocleWindow monocleWindow = this.state.getWindow(false);
        boolean bl6 = this.state.getButtonsPressed().isEmpty();
        MonocleWindow monocleWindow2 = mouseState.getWindow(bl6);
        MonocleView monocleView2 = monocleView = monocleWindow2 == null ? null : (MonocleView)monocleWindow2.getView();
        if (monocleWindow != monocleWindow2 && monocleWindow != null) {
            if (!monocleWindow.isEnabled()) {
                RunnableProcessor.runLater(() -> MonocleWindowManager.getInstance().notifyFocusDisabled(monocleWindow));
            } else {
                MonocleView monocleView3 = (MonocleView)monocleWindow.getView();
                if (monocleView3 != null) {
                    n4 = this.state.getModifiers();
                    n3 = this.state.getButton();
                    boolean bl5 = false;
                    n2 = this.state.getX();
                    n = this.state.getY();
                    int n7 = n2 - monocleWindow.getX();
                    int n8 = n - monocleWindow.getY();
                    try {
                        this.postMouseEvent(monocleView3, 226, n3, n7, n8, n2, n, n4, bl5, bl);
                    }
                    catch (RuntimeException runtimeException) {
                        Application.reportException(runtimeException);
                    }
                }
            }
        }
        boolean bl3 = bl2 = this.state.getX() != n5 || this.state.getY() != n6;
        if (bl2) {
            NativePlatformFactory.getNativePlatform().getCursor().setLocation(n5, n6);
        }
        if (monocleView == null) {
            mouseState.copyTo(this.state);
            return;
        }
        if (monocleWindow2 != null && !monocleWindow2.isEnabled()) {
            mouseState.copyTo(this.state);
            RunnableProcessor.runLater(() -> MonocleWindowManager.getInstance().notifyFocusDisabled(monocleWindow2));
            return;
        }
        n4 = n5 - monocleWindow2.getX();
        n3 = n6 - monocleWindow2.getY();
        if (monocleWindow != monocleWindow2 && monocleView != null) {
            int mouseState2 = this.state.getModifiers();
            n2 = this.state.getButton();
            n = 0;
            this.postMouseEvent(monocleView, 225, n2, n4, n3, n5, n6, mouseState2, n != 0, bl);
        }
        if (monocleWindow != monocleWindow2 | bl2) {
            boolean mouseState3 = !this.state.getButtonsPressed().isEmpty();
            n2 = mouseState3 ? 223 : 224;
            n = this.state.getModifiers();
            int n9 = this.state.getButton();
            boolean bl4 = false;
            this.postMouseEvent(monocleView, n2, n9, n4, n3, n5, n6, n, bl4, bl);
        }
        mouseState.getButtonsPressed().difference(this.buttons, this.state.getButtonsPressed());
        if (!this.buttons.isEmpty()) {
            MouseState d = new MouseState();
            this.state.copyTo(d);
            for (n2 = 0; n2 < this.buttons.size(); ++n2) {
                n = this.buttons.get(n2);
                d.pressButton(n);
                boolean bl5 = false;
                this.postMouseEvent(monocleView, 221, n, n4, n3, n5, n6, d.getModifiers(), bl5, bl);
            }
        }
        this.buttons.clear();
        this.state.getButtonsPressed().difference(this.buttons, mouseState.getButtonsPressed());
        if (!this.buttons.isEmpty()) {
            MouseState mouseState2 = new MouseState();
            this.state.copyTo(mouseState2);
            for (n2 = 0; n2 < this.buttons.size(); ++n2) {
                n = this.buttons.get(n2);
                mouseState2.releaseButton(n);
                boolean bl7 = false;
                this.postMouseEvent(monocleView, 222, n, n4, n3, n5, n6, mouseState2.getModifiers(), bl7, bl);
            }
        }
        this.buttons.clear();
        if (mouseState.getWheel() != this.state.getWheel()) {
            double d;
            switch (mouseState.getWheel()) {
                case -1: {
                    d = -1.0;
                    break;
                }
                case 1: {
                    d = 1.0;
                    break;
                }
                default: {
                    d = 0.0;
                }
            }
            if (d != 0.0) {
                n = mouseState.getModifiers();
                RunnableProcessor.runLater(() -> monocleView.notifyScroll(n4, n3, n5, n6, 0.0, d, n, 1, 0, 0, 0, 1.0, 1.0));
            }
            mouseState.setWheel(0);
        }
        mouseState.copyTo(this.state);
    }

    private void postMouseEvent(MonocleView monocleView, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        RunnableProcessor.runLater(() -> this.notifyMouse(monocleView, n, n2, n3, n4, n5, n6, n7, bl, bl2));
    }

    private void notifyMouse(MonocleView monocleView, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        switch (n) {
            case 221: {
                if (this.dragButton != 211) break;
                this.dragButton = n2;
                break;
            }
            case 222: {
                if (this.dragButton != n2) break;
                this.dragButton = 211;
                if (!this.dragInProgress) break;
                try {
                    monocleView.notifyDragDrop(n3, n4, n5, n6, 2);
                }
                catch (RuntimeException runtimeException) {
                    Application.reportException(runtimeException);
                }
                try {
                    monocleView.notifyDragEnd(2);
                }
                catch (RuntimeException runtimeException) {
                    Application.reportException(runtimeException);
                }
                ((MonocleApplication)Application.GetApplication()).leaveDndEventLoop();
                this.dragActions.clear();
                this.dragView = null;
                this.dragInProgress = false;
                break;
            }
            case 223: {
                if (this.dragButton == 211) break;
                if (this.dragInProgress) {
                    if (this.dragView == monocleView && this.dragActions.isEmpty()) {
                        try {
                            monocleView.notifyDragEnter(n3, n4, n5, n6, 2);
                        }
                        catch (RuntimeException runtimeException) {
                            Application.reportException(runtimeException);
                        }
                        this.dragActions.set(1);
                    } else if (this.dragView == monocleView && this.dragActions.get(1)) {
                        try {
                            monocleView.notifyDragOver(n3, n4, n5, n6, 2);
                        }
                        catch (RuntimeException runtimeException) {
                            Application.reportException(runtimeException);
                        }
                        this.dragActions.set(3);
                    } else if (this.dragView != monocleView) {
                        if (this.dragView != null) {
                            try {
                                this.dragView.notifyDragLeave();
                            }
                            catch (RuntimeException runtimeException) {
                                Application.reportException(runtimeException);
                            }
                        }
                        try {
                            monocleView.notifyDragEnter(n3, n4, n5, n6, 2);
                        }
                        catch (RuntimeException runtimeException) {
                            Application.reportException(runtimeException);
                        }
                        this.dragActions.clear();
                        this.dragActions.set(1);
                        this.dragView = monocleView;
                    }
                    return;
                }
                if (this.dragView != null) break;
                this.dragView = monocleView;
            }
        }
        monocleView.notifyMouse(n, n2, n3, n4, n5, n6, n7, bl, bl2);
    }

    void notifyDragStart() {
        this.dragInProgress = true;
    }
}

